<?php $__env->startSection('content'); ?>
    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-4">Daftar Absensi Hari Ini</h2>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <!-- Tab Navigation -->
                    <div class="mb-6">
                        <h3 class="text-lg font-medium text-gray-900">Daftar Absensi Hari Ini</h3>
                        <div class="mt-4 flex gap-2">
                            <a href="<?php echo e(route('admin.absensi.export-pdf', ['tanggal' => $tanggal])); ?>" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded text-sm">
                                <i class="fas fa-file-pdf mr-2"></i>Export PDF
                            </a>
                            <a href="<?php echo e(route('admin.absensi.export-excel', ['tanggal' => $tanggal])); ?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-sm">
                                <i class="fas fa-file-excel mr-2"></i>Export Excel
                            </a>
                        </div>
                    </div>

                    <div>
                        <form method="GET" class="mb-4 flex items-center gap-2">
                            <label for="tanggal" class="mr-2">Tanggal:</label>
                            <input type="date" name="tanggal" id="tanggal" value="<?php echo e($tanggal); ?>" class="border rounded px-2 py-1">
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">Tampilkan</button>
                        </form>

                        <?php if(session('success')): ?>
                            <div class="mb-4 p-3 bg-green-100 text-green-800 rounded"><?php echo e(session('success')); ?></div>
                        <?php endif; ?>

                        <?php if($absensi->count() > 0): ?>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admin</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi Input</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jam Masuk</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Foto Masuk</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jam Pulang</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Foto Pulang</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <?php $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                                    <?php echo e($item->user->name ?? $item->nama_karyawan); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php echo e($item->nama_admin ?? '-'); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php echo e($item->lokasi_input ?? '-'); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php echo e($item->jam_masuk ? \Carbon\Carbon::parse($item->jam_masuk)->format('H:i') : '-'); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php if($item->foto_masuk): ?>
                                                        <a href="<?php echo e(asset('storage/'.$item->foto_masuk)); ?>" target="_blank">
                                                            <img src="<?php echo e(asset('storage/'.$item->foto_masuk)); ?>" alt="Foto Masuk" class="h-12 rounded shadow mx-auto">
                                                        </a>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td class="px-6 py-4 text-sm text-gray-500">
                                                    <?php echo e($item->lokasi ?? '-'); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php echo e($item->jam_pulang ? \Carbon\Carbon::parse($item->jam_pulang)->format('H:i') : '-'); ?>

                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    <?php if($item->foto_pulang): ?>
                                                        <a href="<?php echo e(asset('storage/'.$item->foto_pulang)); ?>" target="_blank">
                                                            <img src="<?php echo e(asset('storage/'.$item->foto_pulang)); ?>" alt="Foto Pulang" class="h-12 rounded shadow mx-auto">
                                                        </a>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                        <?php echo e($item->status === 'hadir' ? 'bg-green-100 text-green-800' : 
                                                           ($item->status === 'izin' ? 'bg-yellow-100 text-yellow-800' : 
                                                           ($item->status === 'sakit' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800'))); ?>">
                                                        <?php echo e(ucfirst($item->status)); ?>

                                                    </span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <a href="<?php echo e(route('admin.absensi.edit', $item->id)); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded text-xs mr-2">Edit</a>
                                                    <form action="<?php echo e(route('admin.absensi-hari-ini.hapus', $item->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus absensi ini?')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-xs">Hapus</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-8 text-gray-500">Tidak ada data absensi untuk tanggal ini.</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tab contents
            const tabContents = document.querySelectorAll('.tab-content');
            tabContents.forEach(content => {
                content.classList.add('hidden');
            });

            // Remove active class from all tab buttons
            const tabButtons = document.querySelectorAll('.tab-button');
            tabButtons.forEach(button => {
                button.classList.remove('active', 'border-blue-500', 'text-blue-600');
                button.classList.add('border-transparent', 'text-gray-500');
            });

            // Show selected tab content
            document.getElementById('tab-content-' + tabName).classList.remove('hidden');

            // Add active class to selected tab button
            document.getElementById('tab-' + tabName).classList.add('active', 'border-blue-500', 'text-blue-600');
            document.getElementById('tab-' + tabName).classList.remove('border-transparent', 'text-gray-500');
        }

        // Initialize with first tab active
        document.addEventListener('DOMContentLoaded', function() {
            showTab('daftar');
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\AbsensiKaryawan\resources\views/admin/absensi-hari-ini.blade.php ENDPATH**/ ?>