<!DOCTYPE html>
<html>
<head>
    <title>Laporan Absensi Mingguan</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 5px;
            text-align: left;
        }
        th {
            background-color: #f3f4f6;
        }
    </style>
</head>
<body>
    <h2>Laporan Absensi Mingguan</h2>
    <p>Periode: <?php echo e(\Carbon\Carbon::parse($tanggal_awal)->format('d-m-Y')); ?> s/d <?php echo e(\Carbon\Carbon::parse($tanggal_akhir)->format('d-m-Y')); ?></p>
    
    <table>
        <thead>
            <tr>
                <th>Nama</th>
                <th>Admin</th>
                <th>Tanggal</th>
                <th>Jam Masuk</th>
                <th>Jam Pulang</th>
                <th>Total Jam</th>
                <th>Jam Lembur</th>
                <th>Lokasi</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->user->name ?? $item->nama_karyawan); ?></td>
                    <td><?php echo e($item->nama_admin ?? '-'); ?></td>
                    <td><?php echo e($item->tanggal->format('d/m/Y')); ?></td>
                    <td><?php echo e($item->jam_masuk ? \Carbon\Carbon::parse($item->jam_masuk)->format('H:i') : '-'); ?></td>
                    <td><?php echo e($item->jam_pulang ? \Carbon\Carbon::parse($item->jam_pulang)->format('H:i') : '-'); ?></td>
                    <td><?php echo e($item->total_jam ? $item->getTotalJamFormatted() : '-'); ?></td>
                    <td><?php echo e($item->jam_lembur > 0 ? $item->getJamLemburFormatted() : '-'); ?></td>
                    <td><?php echo e($item->lokasi ?? '-'); ?></td>
                    <td><?php echo e(ucfirst($item->status)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH C:\xampp\htdocs\AbsensiKaryawan\resources\views/admin/exports/absensi-mingguan-pdf.blade.php ENDPATH**/ ?>