<?php $__env->startSection('content'); ?>
    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-4">Edit Absensi Karyawan</h2>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <form action="<?php echo e(route('admin.absensi.update', $absensi->id)); ?>" method="POST" enctype="multipart/form-data" class="space-y-4">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nama Karyawan</label>
                            <input type="text" value="<?php echo e($absensi->user->name ?? $absensi->nama_karyawan); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2 bg-gray-100" readonly>
                        </div>
                        <div class="mb-4">
                            <label for="lokasi" class="block text-sm font-medium text-gray-700 mb-1">Lokasi</label>
                            <input type="text" name="lokasi" id="lokasi" value="<?php echo e(old('lokasi', $absensi->lokasi)); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2">
                            <?php $__errorArgs = ['lokasi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-red-500 text-xs mt-1"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="jam_masuk" class="block text-sm font-medium text-gray-700 mb-1">Jam Masuk</label>
                                <input type="time" name="jam_masuk" id="jam_masuk" value="<?php echo e($absensi->jam_masuk ? \Carbon\Carbon::parse($absensi->jam_masuk)->format('H:i') : ''); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2">
                            </div>
                            <div>
                                <label for="jam_pulang" class="block text-sm font-medium text-gray-700 mb-1">Jam Pulang</label>
                                <input type="time" name="jam_pulang" id="jam_pulang" value="<?php echo e($absensi->jam_pulang ? \Carbon\Carbon::parse($absensi->jam_pulang)->format('H:i') : ''); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2">
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="foto_masuk" class="block text-sm font-medium text-gray-700 mb-1">Foto Masuk (Opsional)</label>
                                <?php if($absensi->foto_masuk): ?>
                                    <a href="<?php echo e(asset('storage/'.$absensi->foto_masuk)); ?>" target="_blank">
                                        <img src="<?php echo e(asset('storage/'.$absensi->foto_masuk)); ?>" alt="Foto Masuk" class="h-16 rounded shadow mb-2">
                                    </a>
                                <?php endif; ?>
                                <input type="file" name="foto_masuk" id="foto_masuk" accept="image/*" class="w-full border border-gray-300 rounded-md px-3 py-2">
                                <p class="text-xs text-gray-500 mt-1">Format: JPG, PNG, JPEG. Maksimal 2MB</p>
                            </div>
                            <div>
                                <label for="foto_pulang" class="block text-sm font-medium text-gray-700 mb-1">Foto Pulang (Opsional)</label>
                                <?php if($absensi->foto_pulang): ?>
                                    <a href="<?php echo e(asset('storage/'.$absensi->foto_pulang)); ?>" target="_blank">
                                        <img src="<?php echo e(asset('storage/'.$absensi->foto_pulang)); ?>" alt="Foto Pulang" class="h-16 rounded shadow mb-2">
                                    </a>
                                <?php endif; ?>
                                <input type="file" name="foto_pulang" id="foto_pulang" accept="image/*" class="w-full border border-gray-300 rounded-md px-3 py-2">
                                <p class="text-xs text-gray-500 mt-1">Format: JPG, PNG, JPEG. Maksimal 2MB</p>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" id="status" class="w-full border border-gray-300 rounded-md px-3 py-2">
                                <option value="hadir" <?php echo e($absensi->status == 'hadir' ? 'selected' : ''); ?>>Hadir</option>
                                <option value="izin" <?php echo e($absensi->status == 'izin' ? 'selected' : ''); ?>>Izin</option>
                                <option value="sakit" <?php echo e($absensi->status == 'sakit' ? 'selected' : ''); ?>>Sakit</option>
                                <option value="alpha" <?php echo e($absensi->status == 'alpha' ? 'selected' : ''); ?>>Alpha</option>
                            </select>
                        </div>
                        <div class="mb-4">
                            <label for="keterangan" class="block text-sm font-medium text-gray-700 mb-1">Keterangan (Opsional)</label>
                            <input type="text" name="keterangan" id="keterangan" value="<?php echo e($absensi->keterangan); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2">
                        </div>
                        <div class="flex justify-end">
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md font-medium">
                                Simpan Perubahan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\AbsensiKaryawan\resources\views/admin/edit-absensi.blade.php ENDPATH**/ ?>