@extends('layouts.app')

@section('content')
    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-4">Dashboard Karyawan</h2>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Today's Attendance Status -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Status Absensi Hari Ini</h3>
                    
                    @if($absensiHariIni)
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div class="text-center p-4 bg-gray-50 rounded-lg">
                                <div class="text-2xl font-bold text-gray-900">
                                    {{ $absensiHariIni->jam_masuk ? \Carbon\Carbon::parse($absensiHariIni->jam_masuk)->format('H:i') : 'Belum Absen' }}
                                </div>
                                <div class="text-sm text-gray-500">Jam Masuk</div>
                            </div>
                            
                            <div class="text-center p-4 bg-gray-50 rounded-lg">
                                <div class="text-2xl font-bold text-gray-900">
                                    {{ $absensiHariIni->jam_pulang ? \Carbon\Carbon::parse($absensiHariIni->jam_pulang)->format('H:i') : 'Belum Pulang' }}
                                </div>
                                <div class="text-sm text-gray-500">Jam Pulang</div>
                            </div>
                            
                            <div class="text-center p-4 bg-gray-50 rounded-lg">
                                <div class="text-2xl font-bold text-gray-900">
                                    {{ $absensiHariIni->total_jam ? $absensiHariIni->getTotalJamFormatted() : '-' }}
                                </div>
                                <div class="text-sm text-gray-500">Total Jam Kerja</div>
                            </div>
                        </div>
                        
                        @if($absensiHariIni->jam_lembur > 0)
                            <div class="mt-4 text-center p-4 bg-orange-50 rounded-lg">
                                <div class="text-lg font-semibold text-orange-800">
                                    Lembur: {{ $absensiHariIni->getJamLemburFormatted() }}
                                </div>
                            </div>
                        @endif
                    @else
                        <div class="text-center py-8">
                            <div class="text-gray-500 mb-4">Belum ada absensi hari ini</div>
                            <a href="{{ route('absensi.index') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-md transition duration-150 ease-in-out">
                                Mulai Absen
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Tombol Isi Data Karyawan -->
            <div class="flex justify-end mb-4">
                <a href="{{ route('karyawan.isi-data') }}" class="bg-blue-700 hover:bg-blue-800 text-white font-bold py-2 px-6 rounded-lg shadow transition">Isi Data Karyawan</a>
            </div>

            <!-- Quick Actions -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-center">
                        <div class="text-3xl font-bold text-blue-600 mb-2">{{ $totalHadir }}</div>
                        <div class="text-sm text-gray-500">Hadir Bulan Ini</div>
                    </div>
                </div>

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-center">
                        <div class="text-3xl font-bold text-yellow-600 mb-2">{{ $totalIzin }}</div>
                        <div class="text-sm text-gray-500">Izin Bulan Ini</div>
                    </div>
                </div>

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-center">
                        <div class="text-3xl font-bold text-red-600 mb-2">{{ $totalSakit }}</div>
                        <div class="text-sm text-gray-500">Sakit Bulan Ini</div>
                    </div>
                </div>

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-center">
                        <div class="text-3xl font-bold text-orange-600 mb-2">{{ number_format($totalJamLembur, 1) }}</div>
                        <div class="text-sm text-gray-500">Jam Lembur Bulan Ini</div>
                    </div>
                </div>
            </div>

            <!-- Navigation Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Absensi</h3>
                        <div class="space-y-3">
                            <a href="{{ route('absensi.index') }}" class="block w-full text-center bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-md transition duration-150 ease-in-out">
                                Absen Masuk/Pulang
                            </a>
                            <!-- Tombol Riwayat Absensi dihapus -->
                        </div>
                    </div>
                </div>
                <!-- Bagian pengajuan izin & sakit dihapus -->
            </div>

            <!-- Recent Attendance -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-6">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Absensi Bulan Ini</h3>
                    
                    @if($absensiBulanIni->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jam Masuk</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jam Pulang</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Jam</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($absensiBulanIni->take(10) as $absensi)
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                                {{ $absensi->tanggal->format('d/m/Y') }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                {{ $absensi->jam_masuk ? \Carbon\Carbon::parse($absensi->jam_masuk)->format('H:i') : '-' }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                {{ $absensi->jam_pulang ? \Carbon\Carbon::parse($absensi->jam_pulang)->format('H:i') : '-' }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                {{ $absensi->total_jam ? $absensi->getTotalJamFormatted() : '-' }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                    {{ $absensi->status === 'hadir' ? 'bg-green-100 text-green-800' : 
                                                       ($absensi->status === 'izin' ? 'bg-yellow-100 text-yellow-800' : 
                                                       ($absensi->status === 'sakit' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')) }}">
                                                    {{ ucfirst($absensi->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 text-center py-4">Belum ada data absensi bulan ini.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection 