@extends('layouts.app')

@section('content')
    <h2 class="font-semibold text-xl text-gray-800 leading-tight mb-4">Laporan PDF</h2>
    <div class="header">
        <h1>LAPORAN ABSENSI & LEMBUR</h1>
        <p>Periode: {{ now()->format('d/m/Y') }}</p>
        <p>Dicetak pada: {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    <div class="section-title">Rekap Absensi</div>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Admin</th>
                <th>Lokasi Input</th>
                <th>Tanggal</th>
                <th>Jam Masuk</th>
                <th>Jam Pulang</th>
                <th>Total Jam</th>
                <th>Jam Lembur</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($absensi as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item->user->name ?? $item->nama_karyawan }}</td>
                <td>{{ $item->nama_admin ?? '-' }}</td>
                <td>{{ $item->lokasi_input ?? '-' }}</td>
                <td>{{ $item->tanggal->format('d/m/Y') }}</td>
                <td>{{ $item->jam_masuk ? \Carbon\Carbon::parse($item->jam_masuk)->format('H:i') : '-' }}</td>
                <td>{{ $item->jam_pulang ? \Carbon\Carbon::parse($item->jam_pulang)->format('H:i') : '-' }}</td>
                <td>{{ $item->total_jam ? $item->getTotalJamFormatted() : '-' }}</td>
                <td class="lembur">{{ $item->jam_lembur > 0 ? $item->getJamLemburFormatted() : '-' }}</td>
                <td>{{ ucfirst($item->status) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="section-title">Rekap Lembur</div>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Tanggal</th>
                <th>Total Jam Kerja</th>
                <th>Jam Lembur</th>
            </tr>
        </thead>
        <tbody>
            @php $no = 1; @endphp
            @foreach($absensi as $item)
                @if($item->jam_lembur > 0)
                <tr>
                    <td>{{ $no++ }}</td>
                    <td>{{ $item->user->name ?? $item->nama_karyawan }}</td>
                    <td>{{ $item->tanggal->format('d/m/Y') }}</td>
                    <td>{{ $item->getTotalJamFormatted() }}</td>
                    <td class="lembur">{{ $item->getJamLemburFormatted() }}</td>
                </tr>
                @endif
            @endforeach
        </tbody>
    </table>

    <div style="margin-top: 30px;">
        <p><strong>Keterangan:</strong></p>
        <ul>
            <li>Jam kerja normal: 8 jam per hari</li>
            <li>Jam kerja mulai: 09:00</li>
            <li>Lembur dihitung jika total jam kerja > 8 jam</li>
        </ul>
    </div>
@endsection 