<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        $admin = User::create([
            'name' => 'Administrator',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'nip' => 'ADM001',
            'jabatan' => 'Administrator',
            'gaji_pokok' => 5000000,
            'tarif_lembur' => 50000,
            'is_active' => true,
        ]);
        $admin->assignRole('admin');

        // Create karyawan tetap
        $karyawanTetap1 = User::create([
            'name' => 'Ahmad Rizki',
            'email' => 'ahmad@example.com',
            'password' => Hash::make('password'),
            'role' => 'karyawan_tetap',
            'nip' => 'KT001',
            'jabatan' => 'Staff IT',
            'gaji_pokok' => 3500000,
            'tarif_lembur' => 35000,
            'is_active' => true,
        ]);
        $karyawanTetap1->assignRole('karyawan_tetap');

        $karyawanTetap2 = User::create([
            'name' => 'Siti Nurhaliza',
            'email' => 'siti@example.com',
            'password' => Hash::make('password'),
            'role' => 'karyawan_tetap',
            'nip' => 'KT002',
            'jabatan' => 'Staff HR',
            'gaji_pokok' => 3200000,
            'tarif_lembur' => 32000,
            'is_active' => true,
        ]);
        $karyawanTetap2->assignRole('karyawan_tetap');

        // Create karyawan lepas
        $karyawanLepas1 = User::create([
            'name' => 'Budi Santoso',
            'email' => 'budi@example.com',
            'password' => Hash::make('password'),
            'role' => 'karyawan_lepas',
            'nip' => 'KL001',
            'jabatan' => 'Freelance Designer',
            'gaji_pokok' => 2500000,
            'tarif_lembur' => 25000,
            'is_active' => true,
        ]);
        $karyawanLepas1->assignRole('karyawan_lepas');

        $karyawanLepas2 = User::create([
            'name' => 'Dewi Sartika',
            'email' => 'dewi@example.com',
            'password' => Hash::make('password'),
            'role' => 'karyawan_lepas',
            'nip' => 'KL002',
            'jabatan' => 'Freelance Writer',
            'gaji_pokok' => 2000000,
            'tarif_lembur' => 20000,
            'is_active' => true,
        ]);
        $karyawanLepas2->assignRole('karyawan_lepas');
    }
}
