<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::table('absensi', function (Blueprint $table) {
        $table->unsignedBigInteger('admin_id')->nullable()->after('user_id'); // id admin (relasi ke users)
        $table->string('nama_admin')->nullable()->after('admin_id'); // nama admin
        $table->string('lokasi_input')->nullable()->after('nama_admin'); // lokasi input absensi

        // Jika ingin menambahkan foreign key ke tabel users:
        // $table->foreign('admin_id')->references('id')->on('users')->onDelete('set null');
    });
}

public function down()
{
    Schema::table('absensi', function (Blueprint $table) {
        $table->dropColumn(['admin_id', 'nama_admin', 'lokasi_input']);
    });
}
};
