<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rekap_lembur', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->date('tanggal');
            $table->decimal('jam_lembur', 5, 2)->default(0); // Jam lembur dalam format 2.50 = 2 jam 30 menit
            $table->decimal('tarif_lembur', 10, 2)->default(0); // Tarif per jam lembur
            $table->decimal('total_tarif', 10, 2)->default(0); // Total tarif lembur (jam_lembur * tarif_lembur)
            $table->text('keterangan')->nullable();
            $table->enum('status', ['pending', 'disetujui', 'ditolak'])->default('pending');
            $table->foreignId('disetujui_oleh')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('disetujui_pada')->nullable();
            $table->timestamps();
            
            // Index untuk optimasi query
            $table->index(['user_id', 'tanggal']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rekap_lembur');
    }
};
