<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('absensi', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->date('tanggal');
            $table->time('jam_masuk')->nullable();
            $table->time('jam_pulang')->nullable();
            $table->decimal('total_jam', 5, 2)->default(0); // Total jam kerja dalam format 8.50 = 8 jam 30 menit
            $table->decimal('jam_lembur', 5, 2)->default(0); // Jam lembur dalam format 2.50 = 2 jam 30 menit
            $table->enum('status', ['hadir', 'izin', 'sakit', 'alpha'])->default('hadir');
            $table->text('keterangan')->nullable();
            $table->string('lokasi')->nullable();
            $table->enum('tipe_input', ['mandiri', 'admin'])->default('mandiri'); // Mandiri untuk karyawan tetap, admin untuk karyawan lepas
            $table->timestamps();
            
            // Index untuk optimasi query
            $table->index(['user_id', 'tanggal']);
            $table->unique(['user_id', 'tanggal']); // Satu user hanya bisa absen sekali per hari
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('absensi');
    }
};
