<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'nip',
        'jabatan',
        'lokasi',
        'gaji_pokok',
        'tarif_lembur',
        'is_active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'gaji_pokok' => 'decimal:2',
            'tarif_lembur' => 'decimal:2',
            'is_active' => 'boolean',
        ];
    }

    /**
     * Get the user's attendance records.
     */
    public function absensi()
    {
        return $this->hasMany(Absensi::class);
    }

    /**
     * Get the user's overtime records.
     */
    public function rekapLembur()
    {
        return $this->hasMany(RekapLembur::class);
    }

    /**
     * Check if user is admin
     */
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    /**
     * Check if user is permanent employee
     */
    public function isKaryawanTetap()
    {
        return $this->role === 'karyawan_tetap';
    }

    /**
     * Check if user is contract employee
     */
    public function isKaryawanLepas()
    {
        return $this->role === 'karyawan_lepas';
    }

    /**
     * Get today's attendance record
     */
    public function getAbsensiHariIni()
    {
        return $this->absensi()->where('tanggal', today())->first();
    }
}
