<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RekapLembur extends Model
{
    use HasFactory;

    protected $table = 'rekap_lembur';

    protected $fillable = [
        'user_id',
        'tanggal',
        'jam_lembur',
        'tarif_lembur',
        'total_tarif',
        'keterangan',
        'status',
        'disetujui_oleh',
        'disetujui_pada',
    ];

    protected $casts = [
        'tanggal' => 'date',
        'jam_lembur' => 'decimal:2',
        'tarif_lembur' => 'decimal:2',
        'total_tarif' => 'decimal:2',
        'disetujui_pada' => 'datetime',
    ];

    /**
     * Get the user that owns the overtime record.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the admin who approved the overtime.
     */
    public function disetujuiOleh()
    {
        return $this->belongsTo(User::class, 'disetujui_oleh');
    }

    /**
     * Calculate total overtime pay
     */
    public function hitungTotalTarif()
    {
        $this->total_tarif = $this->jam_lembur * $this->tarif_lembur;
        $this->save();
    }

    /**
     * Approve overtime record
     */
    public function setujui($adminId)
    {
        $this->status = 'disetujui';
        $this->disetujui_oleh = $adminId;
        $this->disetujui_pada = now();
        $this->save();
    }

    /**
     * Reject overtime record
     */
    public function tolak($adminId)
    {
        $this->status = 'ditolak';
        $this->disetujui_oleh = $adminId;
        $this->disetujui_pada = now();
        $this->save();
    }

    /**
     * Get formatted overtime hours
     */
    public function getJamLemburFormatted()
    {
        $jam = floor($this->jam_lembur);
        $menit = round(($this->jam_lembur - $jam) * 60);
        return "{$jam} jam {$menit} menit";
    }

    /**
     * Get formatted total pay
     */
    public function getTotalTarifFormatted()
    {
        return 'Rp ' . number_format($this->total_tarif, 0, ',', '.');
    }
}
