<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class KaryawanController extends Controller
{
    // Tampilkan form pengisian data karyawan
    public function formPengisianData()
    {
        $user = Auth::user();
        return view('karyawan.isi-data', compact('user'));
    }

    // Simpan data karyawan
    public function simpanPengisianData(Request $request)
    {
        $user = Auth::user();
        $request->validate([
            'nip' => 'required|string|max:20|unique:users,nip,' . $user->id,
            'jabatan' => 'required|string|max:100',
            'lokasi' => 'required|string|max:255',
        ]);
        $user->update([
            'nip' => $request->nip,
            'jabatan' => $request->jabatan,
            'lokasi' => $request->lokasi,
            'role' => 'karyawan_tetap',
            'is_active' => true,
        ]);
        if ($user->role === 'admin') {
            return redirect()->route('admin.dashboard')->with('success', 'Data karyawan berhasil disimpan.');
        }
        return redirect()->route('dashboard')->with('success', 'Data karyawan berhasil disimpan.');
    }
} 