<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Absensi;

class AbsensiRecalculateAll extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:absensi-recalculate-all';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Hitung ulang total jam dan lembur untuk semua data absensi';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $bar = $this->output->createProgressBar(Absensi::count());
        $bar->start();
        $updated = 0;
        foreach (Absensi::all() as $absensi) {
            $absensi->hitungTotalJam();
            $updated++;
            $bar->advance();
        }
        $bar->finish();
        $this->newLine();
        $this->info("\nSelesai! $updated data absensi telah dihitung ulang.");
    }
}
